---
title: Overview · Cloudflare API Shield docs
description: APIs have become the backbone of popular web services, helping the
  Internet become more accessible and useful.
lastUpdated: 2025-10-08T15:21:13.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/api-shield/
  md: https://developers.cloudflare.com/api-shield/index.md
---

Identify and address your API vulnerabilities.

Enterprise-only paid add-on

Note

Enterprise customers can preview this product as a [non-contract service](https://developers.cloudflare.com/billing/preview-services/), which provides full access, free of metered usage fees, limits, and certain other restrictions.

## Why care about API security?

APIs have become the [backbone of popular web services](https://blog.postman.com/intro-to-apis-history-of-apis/), helping the Internet become more accessible and useful.

As APIs have become more prevalent, however, so have their problems:

* Many companies have [thousands of APIs](https://developers.cloudflare.com/api-shield/security/api-discovery/), including ones they do not even know about.
* To support a large base of users, many APIs are protected by a negative security model that makes them vulnerable to credential-stuffing attacks and automated scanning tools.
* With so many endpoints and users, it’s difficult to recognize brute-force attacks against [specific endpoints](https://developers.cloudflare.com/api-shield/security/volumetric-abuse-detection/).
* Sophisticated attacks are even harder to recognize, often because even development teams are unaware of common and uncommon [usage patterns](https://developers.cloudflare.com/api-shield/security/sequence-analytics/).

Refer to the [Get started](https://developers.cloudflare.com/api-shield/get-started/) guide to set up API Shield.

## Features

### Security features

Secure your APIs using API Shield's security features.

[Use Security features](https://developers.cloudflare.com/api-shield/security/)

### Management, monitoring, and more

Monitor the health of your API endpoints.

[Use Management, monitoring, and more](https://developers.cloudflare.com/api-shield/management-and-monitoring/)

## Availability

Cloudflare API Security products are available to Enterprise customers only, though anyone can set up [Mutual TLS](https://developers.cloudflare.com/api-shield/security/mtls/) with a Cloudflare-managed certificate authority.

The full API Shield security suite is available as an Enterprise-only paid add-on, but all customers can access [Endpoint Management](https://developers.cloudflare.com/api-shield/management-and-monitoring/) and [Schema validation](https://developers.cloudflare.com/api-shield/security/schema-validation/) functionalities.

Note

API Shield currently does not work for JDCloud customers.

## Related products

**[DDoS Protection](https://developers.cloudflare.com/ddos-protection/)**

Cloudflare DDoS protection secures websites, applications, and entire networks while ensuring the performance of legitimate traffic is not compromised.
