---
title: Review inline AI use · Cloudflare Learning Paths
description: "To review how your organization uses AI apps, start with the
  Cloudflare Shadow IT dashboard. You can filter the dashboard by application
  type and sort by Artificial Intelligence, which allows you to take several
  valuable actions, such as:"
lastUpdated: 2025-08-26T10:01:18.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/learning-paths/holistic-ai-security/monitor-ai-use/review-inline-ai-use/
  md: https://developers.cloudflare.com/learning-paths/holistic-ai-security/monitor-ai-use/review-inline-ai-use/index.md
---

To review how your organization uses AI apps, start with the Cloudflare [Shadow IT dashboard](https://developers.cloudflare.com/cloudflare-one/insights/analytics/shadow-it-discovery/). You can filter the dashboard by application type and sort by Artificial Intelligence, which allows you to take several valuable actions, such as:

* Reviewing application usage: See which applications your users are engaging with and how often, based on traffic from connected devices or sites.
* Accessing application details: Learn more about the applications in use by reviewing their entries in the App Library.
* Designating application status: Use a [status marker](https://developers.cloudflare.com/cloudflare-one/insights/analytics/shadow-it-discovery/#approval-status) to categorize applications, so you can apply specific security policies to them.

![Shadow IT dashboard showing utilization of application statuses (Approved, Unapproved, In Review, Unreviewed).](https://developers.cloudflare.com/_astro/shadowit-dashboard-ai-apps.Dbzn4dka_CHA6p.webp)

This approach is most relevant for applications that your organization has not yet sanctioned. For example, if your business uses Google Workspace and its primary AI tool is Gemini, you would likely mark Gemini as *Approved*. While you can configure more specific data loss policies later, you can also target approved applications with greater specificity to detect risks unique to your organization.

![The App Library filtered to show some of the supported Artificial Intelligence applications.](https://developers.cloudflare.com/_astro/ai-app-type-app-library.C5AB815M_Z2dzOwT.webp)
